/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.container;

import com.mojang.datafixers.util.Pair;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IPerkProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.container.AbstractContainer;
import dev.toma.gunsrpg.common.init.ModContainers;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.item.perk.Crystal;
import dev.toma.gunsrpg.common.item.perk.CrystalItem;
import dev.toma.gunsrpg.common.item.perk.PerkItem;
import dev.toma.gunsrpg.common.item.perk.PerkVariant;
import java.util.Collections;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class CrystalStationContainer
extends AbstractContainer {
    public static final ResourceLocation EMPTY_CRYSTAL_SLOT = GunsRPG.makeResource("item/empty_crystal");
    public static final ResourceLocation EMPTY_TRANSMUTATION_SLOT = GunsRPG.makeResource("item/empty_orb_of_transmutation");
    public static final ResourceLocation EMPTY_PURITY_SLOT = GunsRPG.makeResource("item/empty_orb_of_purity");
    private final Inventory temporalInventory;

    public CrystalStationContainer(int windowId, PlayerInventory inventory) {
        super((ContainerType<? extends AbstractContainer>)((ContainerType)ModContainers.CRYSTAL_STATION.get()), windowId);
        IPlayerData data = PlayerData.getUnsafe(inventory.field_70458_d);
        ISkillProvider provider = data.getSkillProvider();
        int rows = provider.hasSkill(Skills.CRYSTALIZED) ? 2 : 1;
        this.temporalInventory = new Inventory(rows * 6);
        this.loadInventory(data);
        IntReferenceHolder referenceHolder = IntReferenceHolder.func_221492_a();
        this.func_216958_a(referenceHolder);
        BooleanSupplier supplier = () -> data.getPerkProvider().getPoints() > 0;
        for (int y = 0; y < rows; ++y) {
            for (PerkVariant variant : PerkVariant.values()) {
                int x = variant.ordinal();
                this.func_75146_a(new PerkSlot((IInventory)this.temporalInventory, x + y * 6, 20 + x * 24, 16 + y * 24, variant, supplier));
            }
        }
        this.addPlayerInventory(inventory, 74);
        referenceHolder.func_221494_a(1);
        this.func_75132_a(new ContainerListener(data, this.temporalInventory.func_70302_i_()));
        referenceHolder.func_221494_a(0);
    }

    public CrystalStationContainer(int windowId, PlayerInventory inventory, PacketBuffer buffer) {
        this(windowId, inventory);
    }

    public ItemStack func_82846_b(PlayerEntity player, int slot) {
        return ItemStack.field_190927_a;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    private void loadInventory(IPlayerData data) {
        Map<PerkVariant, CrystalItem> map = CrystalStationContainer.mapCrystalVariants();
        IPerkProvider provider = data.getPerkProvider();
        for (int i = 0; i < this.temporalInventory.func_70302_i_(); ++i) {
            Crystal crystal = provider.getCrystal(i);
            if (crystal == null) continue;
            PerkVariant variant = PerkVariant.byId(i);
            CrystalItem item = map.get((Object)variant);
            this.temporalInventory.func_70299_a(i, crystal.asItem(item));
        }
    }

    public static Map<PerkVariant, CrystalItem> mapCrystalVariants() {
        return ForgeRegistries.ITEMS.getValues().stream().filter(it -> it instanceof CrystalItem).map(it -> (CrystalItem)it).collect(Collectors.toMap(PerkItem::getVariant, Function.identity()));
    }

    private static class ContainerListener
    implements IContainerListener {
        private final IPlayerData data;
        private boolean acceptingEvents;
        private final int slotCount;

        public ContainerListener(IPlayerData data, int slotCount) {
            this.data = data;
            this.slotCount = slotCount;
        }

        public void func_71110_a(Container container, NonNullList<ItemStack> items) {
        }

        public void func_71111_a(Container container, int slot, ItemStack itemStack) {
            if (!this.acceptingEvents) {
                return;
            }
            if (slot < this.slotCount) {
                IPerkProvider provider = this.data.getPerkProvider();
                if (itemStack.func_190926_b()) {
                    provider.setCrystal(slot, null);
                } else {
                    Crystal crystal;
                    CompoundNBT nbt = itemStack.func_77978_p();
                    if (nbt == null) {
                        crystal = new Crystal(0, Collections.emptyList());
                    } else {
                        CompoundNBT crystalNbt = nbt.func_74775_l("crystal");
                        crystal = Crystal.fromNbt(crystalNbt);
                    }
                    provider.setCrystal(slot, crystal);
                    provider.setCooldown(GunsRPG.config.world.crystalStationUseCooldown);
                    provider.awardPoints(-1);
                }
            }
        }

        public void func_71112_a(Container container, int id, int data) {
            if (id == 0) {
                this.acceptingEvents = data == 0;
            }
        }
    }

    public class PerkSlot
    extends Slot {
        private final PerkVariant variant;
        private final BooleanSupplier sufficientFundsSupplier;

        public PerkSlot(IInventory inventory, int index, int x, int y, PerkVariant variant, BooleanSupplier sufficientFundsSupplier) {
            super(inventory, index, x, y);
            this.variant = variant;
            this.sufficientFundsSupplier = sufficientFundsSupplier;
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.sufficientFundsSupplier.getAsBoolean() && stack.func_77973_b() instanceof CrystalItem && ((CrystalItem)stack.func_77973_b()).getVariant() == this.variant;
        }

        public boolean func_82869_a(PlayerEntity entity) {
            return true;
        }

        public void func_75218_e() {
            CrystalStationContainer.this.func_75142_b();
            super.func_75218_e();
        }

        @OnlyIn(value=Dist.CLIENT)
        @Nullable
        public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
            return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)EMPTY_CRYSTAL_SLOT);
        }
    }
}

